// C:\src\Clientes\Datetime\services\explorerService.js
const User = require('../models/users');
const { AppError } = require('../config/errors');
const logger = require('../config/logger');

const production = true;

class ExplorerService {
  async updateExplorerSettings(userId, { explorer, explorer_type }) {
    try {
      if (userId == null) throw new AppError('Usuário inválido', 400);
      //if (production) logger.debug(`Atualizando configurações do Explorer para usuário ${userId}`);

      const ok = await User.updateExplorer(userId, { explorer, explorer_type });
      if (!ok) throw new AppError('Falha ao atualizar configurações', 500);

      return { success: true };
    } catch (error) {
      logger.error('Erro no explorerService.updateExplorerSettings:', error);
      throw error;
    }
  }

  // <<< Nota: recebe o ID autenticado vindo do controller
  async getExplorerUsers(currentUserId) {
    try {
      if (currentUserId == null) throw new AppError('Usuário inválido', 400);
      //if (production) logger.debug(`Buscando usuários do Explorer para ${currentUserId}`);

      const users = await User.getExplorerUsers(currentUserId);
      return Array.isArray(users) ? users : (users ? [users] : []);
    } catch (error) {
      logger.error('Erro no explorerService.getExplorerUsers:', error);
      throw error;
    }
  }
}

module.exports = new ExplorerService();
