const express = require('express');
const router = express.Router();
const chatHistoryController = require('../controllers/chatHistoryController');
const authMiddleware = require('../middlewares/authMiddleware');

// Rotas protegidas por autenticação
router.use(authMiddleware.requireAuth);


// Rotas de API
router.get('/history/:id', chatHistoryController.getHistory);

module.exports = router;