// C:\src\Clientes\Datetime\public\js\profile.js

// fetch com refresh automático
async function fetchWithRefresh(input, init = {}) {
  const exec = async () => fetch(input, { credentials: 'include', ...init });
  let res = await exec();
  if ([401, 403, 419].includes(res.status)) {
    const rt = await fetch('/auth/refresh', {
      method: 'POST', credentials: 'include', headers: { 'Content-Type': 'application/json' }
    });
    if (rt.ok) res = await exec();
  }
  return res;
}

async function parseJsonSafe(res) {
  const ct = (res.headers.get('content-type') || '').toLowerCase();
  if (!ct.includes('application/json')) {
    const text = await res.text();
    throw new Error(`Resposta não-JSON (${res.status} ${res.statusText}). Trecho: ${text.slice(0,200)}`);
  }
  return res.json();
}

function showAlert(msg, type = 'success') {
  const el = document.getElementById('alert');
  el.textContent = msg;
  el.className = 'alert ' + (type === 'error' ? 'alert--error' : 'alert--success');
  el.hidden = false;
  setTimeout(() => { el.hidden = true; }, 3500);
}

/* =======================
   Catálogos / Opções
======================= */
const OPTIONS = {
  pronouns: [
    { value: '', label: 'Selecione…' },
    { value: 'ela/dela', label: 'Ela/Dela' },
    { value: 'ele/dele', label: 'Ele/Dele' },
    { value: 'elu/delu', label: 'Elu/Delu' }
  ],
  relationship_goals: [
    { value: 'amizade', label: 'Amizade' },
    { value: 'casual', label: 'Casual' },
    { value: 'namoro', label: 'Namoro' },
    { value: 'casamento', label: 'Casamento' },
    { value: 'networking', label: 'Networking' },
    { value: 'parceria', label: 'Parceria criativa' },
    { value: 'nao_sei', label: 'Não sei ainda' },
  ],
  relationship_type: [
    { value: 'monogamico', label: 'Monogâmico' },
    { value: 'aberto', label: 'Aberto' },
    { value: 'poliamor', label: 'Poliamor' },
    { value: 'discreto', label: 'Discreto' },
    { value: 'nao_sei', label: 'Não sei ainda' },
  ],
  // NOVO: opções de filhos (conforme solicitado)
  has_children: [
    { value: 'tenho_nao_quero_mais', label: 'Tenho, e não quero mais um.' },
    { value: 'tenho', label: 'Tenho' },
    { value: 'tenho_quero_mais', label: 'Tenho e quero mais.' },
    { value: 'nao_tenho_nao_quero', label: 'Não tenho, e não quero' },
    { value: 'nao_tenho_aberto', label: 'Não tenho mas estou aberto(a)' },
    { value: 'prefiro_nao_dizer', label: 'Prefiro não dizer' },
  ],
  drinks: [
    { value: 'nao', label: 'Não' },
    { value: 'socialmente', label: 'Socialmente' },
    { value: 'raramente', label: 'Raramente' },
    { value: 'frequentemente', label: 'Frequentemente' },
  ],
  smokes: [
    { value: 'nao', label: 'Não' },
    { value: 'ocasional', label: 'Ocasional' },
    { value: 'vape', label: 'Vape' },
    { value: 'sim', label: 'Sim' },
  ],
  political_orientation: [
    { value: 'esquerda', label: 'Esquerda' },
    { value: 'centro_esquerda', label: 'Centro-esquerda' },
    { value: 'centro', label: 'Centro' },
    { value: 'centro_direita', label: 'Centro-direita' },
    { value: 'direita', label: 'Direita' },
    { value: 'libertario', label: 'Libertário' },
    { value: 'independente', label: 'Independente' },
    { value: 'prefiro_nao_dizer', label: 'Prefiro não dizer' },
  ],
  religion: [
    { value: 'catolico', label: 'Católico(a)' },
    { value: 'evangelico', label: 'Evangélico(a)' },
    { value: 'espirita', label: 'Espírita' },
    { value: 'umbanda_candomble', label: 'Umbanda/Candomblé' },
    { value: 'judaico', label: 'Judaico(a)' },
    { value: 'muculmano', label: 'Muçulmano(a)' },
    { value: 'budista', label: 'Budista' },
    { value: 'agnostico', label: 'Agnóstico(a)' },
    { value: 'ateu', label: 'Ateu/Atéia' },
    { value: 'outra', label: 'Outra' },
    { value: 'prefiro_nao_dizer', label: 'Prefiro não dizer' },
  ],
  kitchen_persona: [
    { value: 'chef_fim_de_semana', label: 'Chef de fim de semana' },
    { value: 'mestre_microondas', label: 'Mestre do micro-ondas' },
    { value: 'rei_da_airfryer', label: 'Rei/Rainha da airfryer' },
    { value: 'tempero_da_vovo', label: 'Tempero da vovó' },
    { value: 'queima_ate_gelo', label: 'Queima até gelo' },
  ],
  diet_style: [
    { value: 'conto_macros', label: 'Conto macros' },
    { value: 'low_carb', label: 'Low-carb quando dá' },
    { value: 'vegetariano', label: 'Vegetariano(a)' },
    { value: 'vegano', label: 'Vegano(a)' },
    { value: 'onivoro_feliz', label: 'Onívoro(a) feliz' },
    { value: 'segunda_sem_carne', label: 'Só segunda sem carne' },
    { value: 'jejum_intermitente', label: 'Jejum intermitente' },
    { value: 'nao_faco_ideia', label: 'Não faço ideia 😅' },
  ],
  pets: [
    { value: 'team_dogs', label: 'Team dogs' },
    { value: 'team_cats', label: 'Team cats' },
    { value: 'amo_todos', label: 'Amo todos' },
    { value: 'alergia_mas_tento', label: 'Tenho alergia mas tento' },
    { value: 'peixes_e_plantas', label: 'Peixes e plantas' },
    { value: 'prefiro_plantas', label: 'Prefiro plantas' },
  ],
  coffee: [
    { value: 'sempre', label: 'Sempre!' },
    { value: 'com_acucar', label: 'Só com açúcar' },
    { value: 'com_leite', label: 'Com leite' },
    { value: 'descafeinado', label: 'Descafeinado' },
    { value: 'cha', label: 'Chá, por favor' },
    { value: 'nao_curto', label: 'Não curto' },
  ],
  sports_role: [
    { value: 'atleta_dedicado', label: 'Atleta dedicado(a)' },
    { value: 'torcedor_de_sofa', label: 'Torcedor(a) de sofá' },
    { value: 'domingo_no_parque', label: 'Domingo no parque' },
    { value: 'marombeiro', label: 'Marombeiro(a)' },
    { value: 'yoga_pilates', label: 'Yoga/Pilates' },
    { value: 'corrida', label: 'Corrida' },
    { value: 'ciclista', label: 'Ciclista' },
  ],
  // “Na balada eu…” + novas opções
  party_style: [
    { value: 'dj_improvisado', label: 'DJ improvisado' },
    { value: 'guardiao_da_bolsa', label: 'Guardião(ã) da bolsa' },
    { value: 'dono_da_roda', label: 'Dono(a) da roda de conversa' },
    { value: 'primeiro_na_pista', label: 'Primeiro(a) na pista' },
    { value: 'volta_com_batata', label: 'Some e volta com batata' },
    { value: 'fotografo', label: 'Fotógrafo(a) do rolê' },
    { value: 'deus_me_livre', label: 'Deus me livre' },
    { value: 'prefiro_nem_ir', label: 'Prefiro nem ir' },
  ],
  gangster_persona: [
    { value: 'estrategista', label: 'O estrategista' },
    { value: 'motorista_fuga', label: 'O motorista de fuga' },
    { value: 'hacker', label: 'O hacker' },
    { value: 'pacificador', label: 'O pacificador' },
    { value: 'esquece_senha', label: 'O que esquece a senha' },
  ],
  with_you: [
    'Rir alto', 'Viajar', 'Maratonar séries', 'Treinar junto', 'Cozinhar',
    'Conhecer cafés', 'Dançar', 'Conversas profundas', 'Descobrir a cidade'
  ],
  perfect_day: [
    'Céu aberto e parque', 'Café e livro', 'Praia sem pressa', 'Road trip',
    'Museu e pizza', 'Cozinha experimental', 'Filme e cobertor'
  ],
  socialNetworks: [
    'Instagram', 'X/Twitter', 'LinkedIn', 'Facebook', 'TikTok', 'YouTube', 'Site/Portfólio', 'Outro'
  ]
};

function fillSelect(el, arr, withEmpty = true) {
  if (withEmpty) el.innerHTML = '<option value="">Selecione…</option>';
  arr.forEach(o => {
    const opt = document.createElement('option');
    opt.value = o.value; opt.textContent = o.label;
    el.appendChild(opt);
  });
}

/* Chips simples (array de labels) */
function chipGroup(container, values, selected, onChange) {
  container.innerHTML = '';
  values.forEach(label => {
    const el = document.createElement('button');
    el.type = 'button';
    el.className = 'tag' + (selected.includes(label) ? ' is-selected' : '');
    el.textContent = label;
    el.addEventListener('click', () => {
      const idx = selected.indexOf(label);
      if (idx >= 0) selected.splice(idx, 1); else selected.push(label);
      el.classList.toggle('is-selected');
      onChange([...selected]);
    });
    container.appendChild(el);
  });
}

/* Chips com catálogo de {slug,label} (para Interesses/Hobbies) */
function chipCatalog(container, catalog, selectedSlugs, onChange) {
  container.innerHTML = '';
  catalog.forEach(item => {
    const isSel = selectedSlugs.includes(item.slug);
    const el = document.createElement('button');
    el.type = 'button';
    el.className = 'tag' + (isSel ? ' is-selected' : '');
    el.textContent = item.label;
    el.dataset.slug = item.slug;
    el.addEventListener('click', () => {
      const slug = el.dataset.slug;
      const i = selectedSlugs.indexOf(slug);
      if (i >= 0) selectedSlugs.splice(i, 1); else selectedSlugs.push(slug);
      el.classList.toggle('is-selected');
      onChange([...selectedSlugs]);
    });
    container.appendChild(el);
  });
}

/* ===== Redes sociais (corrigido: não perder referência do objeto) ===== */
function renderSocialRow(target, item, onChange, onRemove) {
  const row = document.createElement('div');
  row.className = 'form-2';
  row.style.alignItems = 'end';
  row.innerHTML = `
    <div>
      <label class="label">Rede</label>
      <select class="select js-net">
        ${OPTIONS.socialNetworks.map(n => `<option value="${n}" ${n === item.network ? 'selected' : ''}>${n}</option>`).join('')}
      </select>
    </div>
    <div class="form-2">
      <div>
        <label class="label">URL</label>
        <input class="input js-url" type="url" placeholder="https://..." value="${item.url || ''}">
      </div>
      <div style="display:flex;gap:8px">
        <button type="button" class="btn btn-outline js-remove" title="Remover"><i class="fa-solid fa-trash"></i></button>
      </div>
    </div>
  `;
  const net = row.querySelector('.js-net');
  const url = row.querySelector('.js-url');
  const rm = row.querySelector('.js-remove');

  const emit = () => {
    // Mutação do mesmo objeto (não perde referência → corrige “só 1ª letra”)
    item.network = net.value;
    item.url = url.value;
    onChange(item);
  };
  net.addEventListener('change', emit);
  url.addEventListener('input', emit);
  rm.addEventListener('click', () => { onRemove(); /* renderAllSocial já é chamado no onRemove */ });


  target.appendChild(row);
}

/* =========== IBGE: Estados/Cidades =========== */
async function getStates() {
  try {
    const r = await fetch('/geo/states', { credentials: 'include' });
    const data = await r.json();
    if (data && data.items) return data.items; // [{uf, nome}]
  } catch { }
  return []; // fallback vazio
}

async function getCitiesByUF(uf) {
  if (!uf) return [];
  try {
    const r = await fetch(`/geo/cities?uf=${encodeURIComponent(uf)}`, { credentials: 'include' });
    const data = await r.json();
    if (data && data.items) return data.items; // [nome...]
  } catch { }
  return [];
}


async function fillStateSelect(stateEl) {
  const states = await getStates();
  stateEl.innerHTML = '<option value="">Selecione o estado…</option>' +
    states.map(s => `<option value="${s.uf}">${s.uf} — ${s.nome}</option>`).join('');
}

async function fillCitySelect(cityEl, uf, selectedCity = '') {
  cityEl.innerHTML = '<option value="">Carregando…</option>';
  cityEl.disabled = true;
  const cities = await getCitiesByUF(uf);
  cityEl.innerHTML = '<option value="">Selecione a cidade…</option>' +
    cities.map(n => `<option value="${n}">${n}</option>`).join('');
  cityEl.disabled = false;
  if (selectedCity) cityEl.value = selectedCity;
}

/* =========== Interesses: catálogo do backend (slug/label) =========== */
let INTEREST_CATALOG = []; // [{slug,label,category}]
async function loadInterestsCatalog() {
  try {
    const r = await fetchWithRefresh('/auth/interests');
    if (!r.ok) throw 0;
    const data = await parseJsonSafe(r);
    INTEREST_CATALOG = Array.isArray(data.items) ? data.items : [];
  } catch {
    INTEREST_CATALOG = []; // se falhar, mantém vazio (chips não aparecem)
  }
}

/* =======================
   DOM Ready / Inicialização
======================= */
document.addEventListener('DOMContentLoaded', () => { init().catch(console.error); });

async function init() {
  const removePictureLink = document.getElementById('removePictureLink');
  const profileForm = document.getElementById('profileForm');
  const usernameDisplay = document.getElementById('username');
  const userEmailDisplay = document.getElementById('userEmail');
  const usernameInput = document.getElementById('usernameInput');
  const emailInput = document.getElementById('emailInput');
  const genderInput = document.getElementById('genderInput');
  const profilePicture = document.getElementById('profilePicture');
  const fileInput = document.getElementById('fileInput');
  const fileName = document.getElementById('fileName');
  const cancelBtn = document.getElementById('cancelBtn');
  const explorerToggle = document.getElementById('explorerToggle');
  const explorerStatus = document.getElementById('explorerStatus');
  const explorerTypeGroup = document.getElementById('explorerTypeGroup');
  const explorerTypeSelect = document.getElementById('explorerTypeSelect');
  const galleryFileInput = document.getElementById('galleryFileInput');
  const galleryGrid = document.getElementById('galleryGrid');

  // NOVOS
  const pronouns = document.getElementById('pronouns');
  const occupation = document.getElementById('occupation');
  const city = document.getElementById('city');
  const state = document.getElementById('state');
  const bio = document.getElementById('bio');

  const relationship_goals = document.getElementById('relationship_goals');
  const relationship_type = document.getElementById('relationship_type');
  const has_children = document.getElementById('has_children');
  const drinks = document.getElementById('drinks');
  const smokes = document.getElementById('smokes');
  const political_orientation = document.getElementById('political_orientation');
  const religion = document.getElementById('religion');

  const kitchen_persona = document.getElementById('kitchen_persona');
  const diet_style = document.getElementById('diet_style');
  const pets = document.getElementById('pets');
  const coffee = document.getElementById('coffee');
  const sports_role = document.getElementById('sports_role');
  const party_style = document.getElementById('party_style');
  const gangster_persona = document.getElementById('gangster_persona');

  const withYouTags = document.getElementById('withYouTags');
  const withYouInput = document.getElementById('withYouInput');
  const perfectDayTags = document.getElementById('perfectDayTags');
  const perfectDayInput = document.getElementById('perfectDayInput');

  const interestsTags = document.getElementById('interestsTags');
  const interestsInput = document.getElementById('interestsInput');

  const socialLinksList = document.getElementById('socialLinksList');
  const addSocialBtn = document.getElementById('addSocialBtn');

  function renderAllSocial() {
    socialLinksList.innerHTML = '';
    if (!Array.isArray(socialLinks)) socialLinks = [];

    // Se quiser sempre manter pelo menos 1 linha visível:
    if (socialLinks.length === 0) {
      socialLinks.push({ network: 'Instagram', url: '' });
    }

    // Renderiza cada linha; handlers atualizam o estado e re-renderizam quando necessário
    socialLinks.forEach((item) => {
      renderSocialRow(
        socialLinksList,
        item,
        // onChange: o item é o mesmo objeto do array -> já está mutado
        () => { },
        // onRemove:
        () => {
          const idx = socialLinks.indexOf(item);
          if (idx >= 0) socialLinks.splice(idx, 1);
          renderAllSocial(); // re-render geral p/ manter índices/eventos coerentes
        }
      );
    });
  }

  // Preenche selects fixos
  fillSelect(pronouns, OPTIONS.pronouns, false);
  fillSelect(relationship_goals, OPTIONS.relationship_goals);
  fillSelect(relationship_type, OPTIONS.relationship_type);
  fillSelect(has_children, OPTIONS.has_children);
  fillSelect(drinks, OPTIONS.drinks);
  fillSelect(smokes, OPTIONS.smokes);
  fillSelect(political_orientation, OPTIONS.political_orientation);
  fillSelect(religion, OPTIONS.religion);
  fillSelect(kitchen_persona, OPTIONS.kitchen_persona);
  fillSelect(diet_style, OPTIONS.diet_style);
  fillSelect(pets, OPTIONS.pets);
  fillSelect(coffee, OPTIONS.coffee);
  fillSelect(sports_role, OPTIONS.sports_role);
  fillSelect(party_style, OPTIONS.party_style);
  fillSelect(gangster_persona, OPTIONS.gangster_persona);

  // Estado/Cidade (IBGE)
  await fillStateSelect(state);
  state.addEventListener('change', async () => {
    const uf = state.value;
    if (!uf) {
      city.innerHTML = '<option value="">Selecione o estado primeiro…</option>';
      city.disabled = true;
      return;
    }
    await fillCitySelect(city, uf);
  });

  // Estado local
  let selectedWithYou = [];
  let selectedPerfectDay = [];
  let selectedInterestsSlugs = [];
  let socialLinks = [];

  chipGroup(withYouTags, OPTIONS.with_you, selectedWithYou, arr => {
    selectedWithYou = arr; withYouInput.value = JSON.stringify(arr);
  });
  chipGroup(perfectDayTags, OPTIONS.perfect_day, selectedPerfectDay, arr => {
    selectedPerfectDay = arr; perfectDayInput.value = JSON.stringify(arr);
  });

  // Social: adicionar linha (corrigido)
  function addSocial() {
    socialLinks.push({ network: 'Instagram', url: '' });
    renderAllSocial();
  }
  addSocialBtn.addEventListener('click', addSocial);

  function toggleRemoveLink(show) {
    removePictureLink.hidden = !show;
  }

  // Carrega catálogo de interesses (slug/label) antes do usuário
  await loadInterestsCatalog();

  async function loadUserData() {
    try {
      const res = await fetchWithRefresh('/auth/me');
      if (!res.ok) throw new Error('Erro ao carregar perfil');
      const user = await parseJsonSafe(res);


      // Cabeçalho
      usernameDisplay.textContent = user.username || 'Sem nome';
      userEmailDisplay.textContent = user.email || '';
      usernameInput.value = user.username || '';
      emailInput.value = user.email || '';

      genderInput.value = user.gender === 'male' ? 'Masculino'
        : user.gender === 'female' ? 'Feminino' : '—';

      // Datas e medidas
      const bd = user.birthDate ? String(user.birthDate).split('T')[0] : '';
      document.getElementById('birthDate').value = bd;
      document.getElementById('height').value = user.height ?? '';
      document.getElementById('weight').value = user.weight ?? '';

      // Pessoal extra
      pronouns.value = user.pronouns || '';
      occupation.value = user.occupation || '';
      bio.value = user.bio || '';

      // Estado/Cidade
      const uf = user.state || '';
      const cityName = user.city || '';
      state.value = uf || '';
      if (uf) { await fillCitySelect(city, uf, cityName); }
      else {
        city.innerHTML = '<option value="">Selecione o estado primeiro…</option>';
        city.disabled = true;
      }

      // Foto
      if (user.profilePicture) { profilePicture.src = user.profilePicture; toggleRemoveLink(true); }
      else { profilePicture.src = '/img/user_placeholder.png'; toggleRemoveLink(false); }

      // Explorer
      const enabled = !!user.explorer;
      explorerToggle.checked = enabled;
      explorerStatus.textContent = enabled ? 'Ativado' : 'Desativado';
      explorerTypeGroup.hidden = !enabled;
      explorerTypeSelect.value = user.explorer_type || 'private';

      // Selects
      relationship_goals.value = user.relationship_goals || '';
      relationship_type.value = user.relationship_type || '';
      has_children.value = user.has_children || '';
      drinks.value = user.drinks || '';
      smokes.value = user.smokes || '';
      political_orientation.value = user.political_orientation || '';
      religion.value = user.religion || '';

      kitchen_persona.value = user.kitchen_persona || '';
      diet_style.value = user.diet_style || '';
      pets.value = user.pets || '';
      coffee.value = user.coffee || '';
      sports_role.value = user.sports_role || '';
      party_style.value = user.party_style || '';
      gangster_persona.value = user.gangster_persona || '';

      // Arrays/JSON
      selectedWithYou = Array.isArray(user.with_you) ? user.with_you : [];
      withYouInput.value = JSON.stringify(selectedWithYou);
      chipGroup(withYouTags, OPTIONS.with_you, selectedWithYou, arr => {
        selectedWithYou = arr; withYouInput.value = JSON.stringify(arr);
      });

      selectedPerfectDay = Array.isArray(user.perfect_day) ? user.perfect_day : [];
      perfectDayInput.value = JSON.stringify(selectedPerfectDay);
      chipGroup(perfectDayTags, OPTIONS.perfect_day, selectedPerfectDay, arr => {
        selectedPerfectDay = arr; perfectDayInput.value = JSON.stringify(arr);
      });

      // Interesses: usar slugs do backend + catálogo
      const slugs = Array.isArray(user.interests) ? user.interests : [];
      selectedInterestsSlugs = slugs;
      interestsInput.value = JSON.stringify(selectedInterestsSlugs);
      if (INTEREST_CATALOG.length) {
        chipCatalog(
          interestsTags,
          INTEREST_CATALOG, // [{slug,label}]
          selectedInterestsSlugs,
          arr => { selectedInterestsSlugs = arr; interestsInput.value = JSON.stringify(arr); }
        );
      } else {
        interestsTags.innerHTML = '<span class="small muted">Catálogo de interesses indisponível</span>';
      }

      // Social links
      socialLinks = Array.isArray(user.social_links)
        ? user.social_links.map(x => ({ network: x.network || 'Instagram', url: x.url || '' }))
        : [];

      renderAllSocial();

    } catch (e) {
      console.error(e);
      showAlert('Erro ao carregar perfil', 'error');
    }
  }

  async function saveExplorerSettings(payload) {
    const res = await fetchWithRefresh('/explorer/settings', {
      method: 'POST',
      headers: { 'Content-Type': 'application/json' },
      body: JSON.stringify(payload)
    });
    if (!res.ok) throw new Error('Falha ao salvar configurações do Explorer');
  }

  // Handlers Explorer
  explorerToggle.addEventListener('change', async (e) => {
    const isChecked = e.target.checked;
    explorerStatus.textContent = isChecked ? 'Ativado' : 'Desativado';
    explorerTypeGroup.hidden = !isChecked;
    try {
      await saveExplorerSettings({ explorer: isChecked ? 1 : 0, explorer_type: explorerTypeSelect.value });
      showAlert('Configurações do Explorer atualizadas.');
    } catch (err) {
      console.error(err);
      showAlert('Erro ao atualizar o Explorer.', 'error');
      explorerToggle.checked = !isChecked;
      explorerStatus.textContent = !isChecked ? 'Ativado' : 'Desativado';
      explorerTypeGroup.hidden = isChecked;
    }
  });
  explorerTypeSelect.addEventListener('change', async (e) => {
    try {
      await saveExplorerSettings({ explorer: explorerToggle.checked ? 1 : 0, explorer_type: e.target.value });
      showAlert('Visibilidade atualizada.');
    } catch (err) {
      console.error(err);
      showAlert('Erro ao atualizar a visibilidade.', 'error');
    }
  });

  // Remover foto
  document.getElementById('removePictureLink').addEventListener('click', async (e) => {
    e.preventDefault();
    if (!confirm('Tem certeza que deseja remover sua foto de perfil?')) return;
    try {
      const res = await fetchWithRefresh('/auth/remove-profile-picture', { method: 'POST' });
      if (!res.ok) throw new Error('Erro ao remover foto');
      profilePicture.src = '/img/user_placeholder.png';
      toggleRemoveLink(false);
      showAlert('Foto removida com sucesso.');
    } catch (err) {
      console.error(err);
      showAlert('Erro ao remover foto.', 'error');
    }
  });

  // Salvar perfil
  profileForm.addEventListener('submit', async (e) => {
    e.preventDefault();
    const btn = profileForm.querySelector('.btn-primary');
    btn.classList.add('loading'); btn.disabled = true;
    try {
      const formData = new FormData();
      formData.append('username', (usernameInput.value || '').trim());
      formData.append('birthDate', document.getElementById('birthDate').value || '');
      formData.append('height', document.getElementById('height').value || '');
      formData.append('weight', document.getElementById('weight').value || '');
      if (fileInput.files[0]) formData.append('profilePicture', fileInput.files[0]);

      // Novos campos
      formData.append('pronouns', pronouns.value || '');
      formData.append('occupation', occupation.value || '');
      formData.append('city', city.value || '');
      formData.append('state', state.value || '');
      formData.append('bio', bio.value || '');

      formData.append('relationship_goals', relationship_goals.value || '');
      formData.append('relationship_type', relationship_type.value || '');
      formData.append('has_children', has_children.value || '');
      formData.append('drinks', drinks.value || '');
      formData.append('smokes', smokes.value || '');
      formData.append('political_orientation', political_orientation.value || '');
      formData.append('religion', religion.value || '');

      formData.append('kitchen_persona', kitchen_persona.value || '');
      formData.append('diet_style', diet_style.value || '');
      formData.append('pets', pets.value || '');
      formData.append('coffee', coffee.value || '');
      formData.append('sports_role', sports_role.value || '');
      formData.append('party_style', party_style.value || '');
      formData.append('gangster_persona', gangster_persona.value || '');

      // JSON arrays
      formData.append('with_you', withYouInput.value);
      formData.append('perfect_day', perfectDayInput.value);

      // Social links
      formData.append('social_links', JSON.stringify(socialLinks));

      // Salva perfil
      let res = await fetchWithRefresh('/auth/update-profile', { method: 'POST', body: formData });
      if (!res.ok) throw new Error('Erro ao atualizar perfil');

      // Salva interesses (slugs)
      const interestsPayload = { interests: JSON.parse(interestsInput.value || '[]') };
      res = await fetchWithRefresh('/auth/update-interests', {
        method: 'POST', headers: { 'Content-Type': 'application/json' }, body: JSON.stringify(interestsPayload)
      });
      if (!res.ok) throw new Error('Erro ao salvar interesses');

      showAlert('Perfil atualizado com sucesso.');
      setTimeout(() => window.location.reload(), 400);
    } catch (err) {
      console.error(err);
      showAlert(err.message || 'Erro ao atualizar perfil', 'error');
      usernameInput.focus();
    } finally {
      btn.classList.remove('loading'); btn.disabled = false;
    }
  });

  // Preview e nome de arquivo
  fileInput.addEventListener('change', () => {
    if (!fileInput.files[0]) {
      fileName.textContent = 'Nenhum arquivo selecionado';
      return;
    }
    fileName.textContent = fileInput.files[0].name;
    const reader = new FileReader();
    reader.onload = (e) => { profilePicture.src = e.target.result; };
    reader.readAsDataURL(fileInput.files[0]);
  });

  // Cancelar
  cancelBtn.addEventListener('click', () => { window.location.href = '/dashboard/rooms'; });

  // Galeria
  function renderGallery(images) {
    galleryGrid.innerHTML = '';
    if (!images || images.length === 0) {
      galleryGrid.innerHTML = '<p class="muted">Sua galeria está vazia. Adicione imagens!</p>';
      return;
    }
    images.forEach(img => {
      const el = document.createElement('div');
      el.className = 'gallery-item';
      el.innerHTML = `
        <img src="${img.image_path || img.path}" alt="Imagem da galeria">
        <button class="delete-btn" title="Excluir" data-id="${img.id}">
          <i class="fas fa-trash-alt"></i>
        </button>
      `;
      galleryGrid.appendChild(el);
    });

    galleryGrid.querySelectorAll('.delete-btn').forEach(btn => {
      btn.addEventListener('click', async (ev) => {
        ev.stopPropagation();
        const imageId = btn.getAttribute('data-id');
        if (!confirm('Excluir esta imagem?')) return;
        try {
          const res = await fetchWithRefresh(`/auth/gallery-image/${imageId}`, { method: 'DELETE' });
          if (!res.ok) throw new Error('Erro ao deletar imagem');
          await loadGalleryImages();
          showAlert('Imagem removida.');
        } catch (err) {
          console.error(err);
          showAlert('Erro ao deletar imagem.', 'error');
        }
      });
    });
  }

  async function loadGalleryImages() {
    try {
      const res = await fetchWithRefresh('/auth/gallery-images');
      if (!res.ok) throw new Error('Erro ao carregar galeria');
      const data = await parseJsonSafe(res);
      renderGallery(data.images || []);
    } catch (err) {
      console.error(err);
      showAlert('Erro ao carregar galeria.', 'error');
    }
  }

  // MULTI upload
  galleryFileInput.addEventListener('change', async () => {
    const files = Array.from(galleryFileInput.files || []);
    if (!files.length) return;
    const formData = new FormData();
    files.forEach(f => formData.append('galleryImages', f));
    try {
      const res = await fetchWithRefresh('/auth/upload-gallery-images', { method: 'POST', body: formData });
      if (!res.ok) throw new Error('Erro ao enviar imagens');
      await res.json();
      await loadGalleryImages();
      galleryFileInput.value = '';
      showAlert('Imagem(ns) adicionada(s) à galeria.');
    } catch (err) {
      console.error(err);
      showAlert('Erro ao enviar imagens.', 'error');
    }
  });

  // Inicializações
  await loadUserData();
  await loadGalleryImages();
}
