const form = document.getElementById('loginForm');
const errorEl = document.getElementById('error');
const btn = document.getElementById('submitBtn');
const psw = document.getElementById('password');
const toggle = document.getElementById('togglePassword');
const capsHint = document.getElementById('capsHint');

toggle.addEventListener('click', () => {
  const type = psw.getAttribute('type') === 'password' ? 'text' : 'password';
  psw.setAttribute('type', type);
  toggle.setAttribute('aria-pressed', type === 'text');
});

psw.addEventListener('keyup', (e) => {
  const caps = e.getModifierState && e.getModifierState('CapsLock');
  capsHint.hidden = !caps;
});

form.addEventListener('submit', async (e) => {
  e.preventDefault();
  errorEl.textContent = '';
  btn.classList.add('loading');
  btn.disabled = true;

  const email = document.getElementById('email').value.trim();
  const password = psw.value;

  // validação simples
  if (!email || !password) {
    errorEl.textContent = 'Preencha email e senha.';
    btn.classList.remove('loading'); btn.disabled = false;
    return;
  }

  try {
    const csrf = sessionStorage.getItem('csrf') || '';
    const res = await fetch('/auth/login', {
      method: 'POST',
      headers: {
        'Content-Type': 'application/json',
        'X-Requested-With': 'XMLHttpRequest',
        'X-CSRF-Token': csrf
      },
      body: JSON.stringify({ email, password}),
      credentials: 'include'
    });

    const data = await res.json().catch(() => ({}));

    if (!res.ok) {
      throw new Error(data.error || 'Não foi possível entrar.');
    }

    location.href = '/dashboard/rooms';
  } catch (err) {
    errorEl.textContent = err.message || 'Erro ao conectar com o servidor.';
  } finally {
    btn.classList.remove('loading'); btn.disabled = false;
  }
});
