// Função para bloquear usuário
async function blockUser(userId) {
    if (!userId) {
        alert('ID do usuário não está definido');
        return;
    }
    
    if (!confirm('Tem certeza que deseja bloquear este usuário?\n\nEsta ação irá:' + 
                 '\n- Remover a amizade (se existir)' +
                 '\n- Cancelar solicitações pendentes' +
                 '\n- Impedir que o usuário veja seu perfil')) {
        return;
    }
    
    try {
        const response = await fetch('/friendship/blocks', {
            method: 'POST',
            headers: {
                'Content-Type': 'application/json',
            },
            body: JSON.stringify({ targetId: userId }),
            credentials: 'include'
        });
        
        if (!response.ok) {
            const errorData = await response.json();
            throw new Error(errorData.error || 'Falha ao bloquear usuário');
        }
        
        alert('Usuário bloqueado com sucesso');
        // Redireciona para a lista de amigos após o bloqueio
        window.location.href = '/friends/list';
    } catch (error) {
        console.error('Erro:', error);
        alert(error.message);
    }
}

// Função para desbloquear usuário
async function unblockUser(userId) {
    if (!confirm('Tem certeza que deseja desbloquear este usuário?')) return;
    
    try {
        const response = await fetch(`/friendship/blocks/${userId}`, {
            method: 'DELETE',
            credentials: 'include'
        });
        
        if (!response.ok) {
            const errorData = await response.json();
            throw new Error(errorData.error || 'Falha ao desbloquear usuário');
        }
        
        alert('Usuário desbloqueado com sucesso');
        // Recarrega a página para atualizar o estado
        window.location.reload();
    } catch (error) {
        console.error('Erro:', error);
        alert(error.message);
    }
}

// Função para lidar com a ação de bloqueio
function handleBlockAction(userId) {
    blockUser(userId);
}

// Função para lidar com a ação de desbloqueio
function handleUnblockAction(userId) {
    unblockUser(userId);
}

// Exporta funções para escopo global
window.blockUser = blockUser;
window.unblockUser = unblockUser;
window.handleBlockAction = handleBlockAction;
window.handleUnblockAction = handleUnblockAction;