// Verificação inicial ao carregar a página
        document.addEventListener('DOMContentLoaded', () => {
            const urlParams = new URLSearchParams(window.location.search);
            const roomId = urlParams.get('roomId');
            const sessionId = urlParams.get('sessionId');

            if (!roomId || !sessionId) {
                console.error('Parâmetros faltando - redirecionando');
                window.location.href = '/?error=invalid_chat_access';
                return;
            }

            // Verifica se tem os dados no sessionStorage
            const chatData = sessionStorage.getItem('chatTransferData');
            if (!chatData) {
                console.error('Dados do chat não encontrados no sessionStorage');
                window.location.href = '/?error=chat_data_missing';
            }
        });