const mysql = require('mysql2/promise');
const dbConfig = require('../config/database');

class Database {
  constructor() {
    this.pool = mysql.createPool({
      ...dbConfig,
      waitForConnections: true,
      connectionLimit: dbConfig.connectionLimit || 10,
      queueLimit: 0,
      decimalNumbers: true
    });
  }
  async query(sql, params) {
    const [rows] = await this.pool.execute(sql, params);
    return rows;
  }
  async getConnection() {
    return this.pool.getConnection();
  }
}
module.exports = new Database();
