// middlewares/errorHandler.js
const { AppError } = require('../config/errors');

function wantsHTML(req) {
  // quando o Accept preferir HTML ou a rota servir páginas
  return req.accepts(['html','json']) === 'html';
}

function errorHandler(err, req, res, next) {
  console.error(err && err.stack ? err.stack : err);

  // AppError customizado
  if (err instanceof AppError) {
    if ((err.status === 401 || err.status === 403) && wantsHTML(req)) {
      return res.redirect('/auth/login');
    }
    return res.status(err.status).json({ error: err.message, status: err.status });
  }

  // JWT
  if (err.name === 'JsonWebTokenError' || err.name === 'TokenExpiredError') {
    if (wantsHTML(req)) return res.redirect('/auth/login?expired=1');
    const msg = err.name === 'TokenExpiredError' ? 'Token expirado' : 'Token inválido';
    return res.status(401).json({ error: msg });
  }

  // Body muito grande (útil quando aumentar limites)
  if (err.type === 'entity.too.large') {
    return res.status(413).json({ error: 'Payload muito grande' });
  }

  // Fallback
  if (wantsHTML(req)) return res.redirect('/auth/login');
  return res.status(500).json({ error: 'Erro interno do servidor' });
}

module.exports = errorHandler;
