// C:\src\Clientes\Datetime\controllers\explorerController.js
const explorerService = require('../services/explorerService');
const logger = require('../config/logger');
const production = false;

exports.updateExplorerSettings = async (req, res, next) => {
  try {
    const { explorer, explorer_type } = req.body;

    if (production) logger.info('Requisição para atualizar configurações do Explorer');

    const result = await explorerService.updateExplorerSettings(
      req.user.id,
      { explorer, explorer_type }
    );

    res.json(result);
  } catch (error) {
    logger.error('Erro no explorerController.updateExplorerSettings:', error);
    next(error);
  }
};

exports.getExplorerUsers = async (req, res, next) => {
  try {
    const users = await explorerService.getExplorerUsers(req.user.id);

    res.json({
      success: true,
      users
    });
  } catch (error) {
    logger.error('Erro no explorerController.getExplorerUsers:', error);
    next(error);
  }
};
