class Logger {
    constructor(environment = 'development') {
        this.environment = environment;
        this.isProduction = environment === 'production';
    }

    setEnvironment(env) {
        this.environment = env;
        this.isProduction = env === 'production';
    }

    log(...args) {
        if (!this.isProduction) {
            console.log(...args);
        }
    }

    info(...args) {
        if (!this.isProduction) {
            console.info(...args);
        }
    }

    warn(...args) {
        if (!this.isProduction) {
            console.warn(...args);
        }
    }

    error(...args) {
        // Erros sempre são mostrados, mesmo em produção
        console.error(...args);
    }

    debug(...args) {
        if (!this.isProduction) {
            console.debug(...args);
        }
    }

    table(...args) {
        if (!this.isProduction) {
            console.table(...args);
        }
    }

    // Método para logs que devem aparecer em qualquer ambiente
    critical(...args) {
        console.error('CRITICAL:', ...args);
    }
}

// Cria uma instância singleton
const loggerInstance = new Logger(process.env.NODE_ENV || 'development');

module.exports = loggerInstance;