// config/appConfig.js
require('dotenv').config();

function clamp(n, min, max) {
  return Math.max(min, Math.min(max, n));
}

/**
 * PHASE_DURATION_SEC:
 * - Aceita valores entre 5s e 600s
 * - Fallback padrão: 20s
 */
const rawPhase = Number.parseInt(process.env.PHASE_DURATION_SEC, 10);
const phaseDurationSec = Number.isFinite(rawPhase) ? clamp(rawPhase, 5, 600) : 20;

module.exports = {
  phaseDurationSec,
};
